*This program exports data to graph the "separated factors" and the "not spearated factors"


*****************
*Set Parameters 
*****************
*set to data files that contains the factors
local Factors_Separate      = "../data/factors_BroadMOM (CNYadj BW36 20001_201310).xls"
local Factors_NotSeparate   = "../data/factors_BroadMOM (CNYadj BW36 20001_201310) NotSeparate.xls"



************************
*Import data
************************
*import estimated factors
foreach type in Separate NotSeparate{
	import excel "`Factors_`type''", firstrow sheet("Factors") clear
	drop if EA1==.
	rename A dated
	rename EA1 EA_`type'
	capture rename PR1 PR_`type'
	capture rename EA2 PR_`type'
	
	*convert the daily date to monthly date
	gen date = mofd(dated)
	drop dated
	format date %tm
	
	save "../data/temp_files/`type'.dta", replace
}

*merge separate and not-separate datasets together
local type Separate
use "../data/temp_files/`type'.dta", clear
local type NotSeparate
merge 1:1 date using "../data/temp_files/`type'.dta"
	*perfect match
drop _merge




**************************
* Graph the factors
***************************
*make year and month variables
gen year  = year(dofm(date))
gen month = month(dofm(date))
drop date
order year month

*multiple PR_NotSeparate by (-1) to get the right sign to match with PR_Separate
replace PR_NotSeparate = PR_NotSeparate*(-1)
export excel using "../output/separate_vs_notseparate [Figure 8].xlsx", firstrow(var) sheet("factor data") sheetreplace


